# Enhanced JavaScript Mode for Lugaru Epsilon

Modern JavaScript (ES2015+), JSX, and JSON support for Lugaru Epsilon.

## Features

### ES2015+ (ES6+) Support
- **Modern Keywords**: `let`, `const`, `async`, `await`, `yield`, `static`, `get`, `set`, `constructor`, `debugger`, `symbol`, `of`, `from`, `as`, `export`, `default`
- **Arrow Functions**: Syntax highlighting for `=>` operators
- **Template Literals**: Full support for template strings with `${expressions}`
- **Classes**: Proper highlighting of class syntax
- **Modules**: `import` and `export` statement support

### JSX Support (React)
- **JSX Tags**: Syntax highlighting for `<Component>` syntax
- **Self-Closing Tags**: Support for `<Component />`
- **JSX Attributes**: Proper coloring of component attributes
- **JSX Expressions**: Embedded JavaScript expressions `{...}`
- **JSX Fragments**: Support for `<>...</>` syntax
- **Nested JSX**: Properly handles nested components

### JSON Support
- Strict JSON syntax highlighting
- Keywords: `true`, `false`, `null`
- Proper string and number coloring

## Installation

### Basic Installation

1. Copy `js-mode.e` to your Epsilon source directory (e.g., `C:\Program Files\Eps14\source\`)

2. Compile the file:
   ```
   cd C:\Program Files\Eps14\source
   eel.exe -s js-mode.e
   ```

3. In Epsilon, load the mode:
   ```
   M-x load-file
   Enter: js-mode
   ```

4. Save your state (optional):
   ```
   M-x write-state
   ```

### File Associations

The mode automatically activates for:
- `.js` - JavaScript files
- `.jsx` - JSX/React files
- `.ts` - TypeScript files (syntax highlighting only)
- `.tsx` - TypeScript JSX files
- `.json` - JSON files

## Usage

### Activating Manually

If needed, you can manually activate the mode:
- `M-x javascript-mode` - For `.js` files
- `M-x jsx-mode` - For `.jsx` files
- `M-x json-mode` - For `.json` files

### Customization

The mode uses Epsilon's C-mode settings for indentation. Customize via:
```
M-x set-variable c-indent
```

### Color Scheme

Syntax highlighting uses your current Epsilon color scheme. The mode defines these color classes:
- `c_keyword` - Keywords like `let`, `const`, `function`
- `c_identifier` - Variable and function names
- `c_string` - String literals
- `c_comment` - Comments
- `c_number` - Numeric literals
- `jsx_tag` - JSX tag names
- `jsx_attribute` - JSX attributes

To change colors:
```
M-x choose-color-scheme
```

## Debugging

If you encounter issues, enable debug tracing by editing `js-mode.e`:

Change line 25 from:
```c
int TRACE_ENABLED = 0;
```
to:
```c
int TRACE_ENABLED = 1;
```

Then recompile and view debug output:
```
M-x switch-to-buffer
Enter: #js-debug#
```

## Supported Epsilon Versions

- Tested on Epsilon 14.06
- May work with other versions

## License

Based on Epsilon's C mode. Limited permission granted by Lugaru Software Ltd.

## Author

Enhanced JavaScript mode contributed by [Your Name]

See CHANGELOG.txt for version history and bug fixes.
