/* tab_size = 8 */

/************************************************************************
* "Epsilon", "EEL" and "Lugaru" are trademarks of Lugaru Software, Ltd. *
*									*
*  Copyright (C) 1985, 1990 Lugaru Software Ltd.  All rights reserved.	*
*									*
* Limited permission is hereby granted to reproduce and modify this	*
* copyrighted material provided that the resulting code is used only in	*
* conjunction with Lugaru products and that this notice is retained in	*
* any such reproduction or modification.				*
*************************************************************************
*  The previous copyright and trademark notice applies to some of the	*
*  code herein. All other changes, enhancements and extension routines	*
*									*
*  Copyright (C) 1992 by Giovanni Zezza					*
*									*
*  These changes may be redistributed free allowed for any purpose	*
*  providing both the Lugaru and my copyrights remain intact.		*
*  I assume no liability for the use or inability to use		*
*  this software. Neither do I take responsibility for any damage	*
*  caused by this software extension.					*
*  This extension may NOT be redistributed for profit.			*
*************************************************************************
* File.......: DBASE.H (header for dBase data & index structure)	*
* Ver........: 1.01                                                     *
* Date.......: 1992-10-06                                               *
* psilon ver: 5.00 & 6.00                                              *
* By.........: Giovanni Zezza						*
*     Address: via Basoli,1						*
*              40137 BOLOGNA						*
*     Country: ITALY							*
*     Tel....: Int +39-51-623 75 77 (GMT + 1h)                          *
*     Fax....: Int +39-51-33 06 66					*
*     FidoNet: 2:332/403 - Active - Bologna - Italy			*
************************************************************************/

//#define LANGUAGE /* if you want english messages */

typedef char  byte;
typedef short word;
typedef int long;

typedef char  boolean;

#define MAX_KEY 256
#define NTX_HEADER_PAGE 272
#define NDX_HEADER_PAGE 512

typedef union
{
	word char_len;
	struct
	{
		byte len;
		byte dec;
	} num_size;
} FIELD_LEN;

typedef struct
{
	byte signature;		/* 03 = dbf, 83 dbf+dbt */
	byte ymd[3];		/* y+1900 m d */
	long last_rec;
	word data_off;
	word rec_size;
	byte pad[20];
} DBF_STRUCT_HEADER;

typedef struct
{
	char field_name[11];
	byte field_type;
	byte dummy[4];
	FIELD_LEN len_info;
	byte filler[14];
} DBF_STRUCT_FIELD;

typedef struct
{
	word sign;
	word version;
	long root;
	long next_page;
	word item_size;
	word key_size;
	word key_dec;
	word max_item;
	word hal_page;
	char key_expr[MAX_KEY];
	boolean unique;
} NTX_INTESTAZIONE;

typedef struct
{
	long start_key_page;
	long total_pages_in_file;
	long filler1;
	word index_key_len;
	word max_key_page;
	word ndx_key_type;
	long size_key_rec;
	byte filler2;
	byte unique;
	char key_name[488];
} NDX_INTESTAZIONE;

typedef union
{
	char db_struct[32];
	DBF_STRUCT_FIELD db_field;
} DBF_FIELD;

typedef union
{
	char db_struct[32];
	DBF_STRUCT_HEADER db_header;
} DBF_HEADER;

typedef union
{
	char ntx_struct[NTX_HEADER_PAGE];
	NTX_INTESTAZIONE ntx_header;
} NTX_HEADER;

typedef union
{
	char ndx_struct[NDX_HEADER_PAGE];
	NDX_INTESTAZIONE ndx_header;
} NDX_HEADER;

/* dBIV - MDX structure definition */

#define TAG_DESC_POS 0x220
#define BLOCK_LEN 512
#define EXPR_FILTER_POS 0x2fa

/* 0x10 Normal; 0x58 Uniq,Desc; 0x50 Uniq; 0x18 Desc */

#define UNIQ_KEY 0x40
#define DESC_KEY 0x08

typedef char EXPR_FILTER[220];

typedef struct
{
   char   two ;                /* Version number (currently 2) */
   char   yymmdd[3] ;          /* Date of last reindex */
   char   data_name[12] ;      /* Name of associated data file */
   char   dummy1[4] ;          /* extra 4 bytes for data-names-not used in DOS */
   short  block_chunks ;       /* Block Size 1 to 32 (512 byte chunks) */
   short  block_rw ;           /* Block Read/Write Size in bytes */
   char   is_production ;      /* 1 if production index, else 0 */
   char   num_slots ;          /* number possible tags (48) */
   short  slot_size ;          /* number bytes/tag slot (32) */
   long   num_tags ;
   long   eof ;
   long   free_list ;          /* start of the free list */
   char   zero[4] ;
   char   create_date[3];      /* Date of index creation */
   char   blank ;
   long   version ;
}  MDX_HEADER_st ;

typedef union
{
	char buf[sizeof(MDX_HEADER_st)];
	MDX_HEADER_st stru;
} MDX_HEADER;

typedef struct
{
   long  header_pos ;          /* Header position (in 512 byte chunks) */
   char  tag[10] ;
   short x1000 ;               /* used for dBASE/SQL expression type  */
   char  left_chld ;
   char  right_chld ;
   char  parent ;
   char  x2 ;
   char  index_type ;
   char  zeros[11] ;
} TAG_DESC_st ;

typedef union
{
	char buf[sizeof(TAG_DESC_st)];
	TAG_DESC_st stru;
} TAG_DESC ;

typedef struct
{
   long           root ;            /* -1 means unknown */
   char           dummy1[4] ;
   char           type_code;        /* 0x10 Normal; 0x58 Uniq,Desc; 0x50 Uniq; 0x18 Desc */
   char           type ;            /* N,D, or C (F is type N)  */
   char           dummy2[2] ;
   short          value_len ;
   short          keys_max ;        /* Maximum # of keys per block;  <= 100  */
   char           dummy3[2] ;
   short          group_len ;       /* value_len plus 4 (MDX); plus 8 (NDX) */
   char           version ;
   char           dummy4 ;
   short          unique   ;        /* 0x4000 (TRUE)if Unique */
   char expr_key[220] ;
}  TAG_HEADER_st ;

typedef union
{
	char buf[sizeof(TAG_HEADER_st)];
	TAG_HEADER_st stru;
}  TAG_HEADER ;

/* table of strings */
/* #define LANGUAGE if you want english messages */

#ifndef LANGUAGE

#define ST_DBF_PROMPT "nome file dbf : "
#define ST_NDX_PROMPT "nome file ndx : "
#define ST_NTX_PROMPT "nome file ntx : "
#define ST_MDX_PROMPT "nome file mdx : "
#define ST_FILE_ERROR "Errore di lettura file"
#define ST_NOT_DBF "Non sembra un file dBase"
#define ST_NOT_NTX "Non sembra un file indice Clipper"
#define ST_NOT_MDX "Non sembra un file indice dBIV"
#define ST_DBF_NAME "Struttura del file"
#define ST_REC_COUNT "Record"
#define ST_REC_LEN "Lunghezza record"
#define ST_FIELDS_COUNT "Numero campi"
#define ST_DATA_OFF "Offset dati"
#define ST_IDX_NAME "File indice"
#define ST_IDX_VERSION "Versione"
#define ST_LAST_REINDEX "Data ultima modifica"
#define ST_LAST_UPDATE "Data ultima modifica"
#define ST_ASSOCIATED_DBF "Nome del file dati associato"
#define ST_IS_PRODUCTION_MDX "Indice di produzione"
#define ST_NOT_PRODUCTION_MDX "Indice non di produzione"
#define ST_INDEX_CREATION "Creato il"
#define ST_ROOT_REC "Record radice"
#define ST_FIRST_PAGE_NTX "Prima pagina indice"
#define ST_TAG_COUNT "Tags presenti"
#define ST_TAG_LIST "Lista tag"
#define ST_TAG_NAME "Tag"
#define ST_TAG_KEY "Chiave"
#define ST_TAG_TYPE "Modalit indice"
#define ST_TAG_FILTER "Filtro"
#define ST_KEY_TYPE "Tipo chiave"
#define ST_KEY_LEN "Lunghezza chiave"
#define ST_UNIQUE "unico"
#define ST_DESC "discendente"
#define ST_DONE "fatto"

#else

#define ST_DBF_PROMPT "dbf file name : "
#define ST_NDX_PROMPT "ndx file name : "
#define ST_NTX_PROMPT "ntx file name : "
#define ST_MDX_PROMPT "mdx file name : "
#define ST_FILE_ERROR "Error reading file"
#define ST_NOT_DBF "Don't seems to be a dBase file"
#define ST_NOT_NTX "Don't seems to be a Clipper index file"
#define ST_NOT_MDX "Don't seems to be a dBIV index file"
#define ST_DBF_NAME "Structure of file"
#define ST_REC_COUNT "Records"
#define ST_REC_LEN "Record's length"
#define ST_FIELDS_COUNT "Number of fields"
#define ST_DATA_OFF "Data offset"
#define ST_IDX_NAME "Index file name"
#define ST_IDX_VERSION "Version number"
#define ST_LAST_REINDEX "Date of last reindex"
#define ST_LAST_UPDATE "Last update"
#define ST_ASSOCIATED_DBF "Name of associated data file"
#define ST_IS_PRODUCTION_MDX "Production index"
#define ST_NOT_PRODUCTION_MDX "Not a production index"
#define ST_INDEX_CREATION "Created"
#define ST_ROOT_REC "Root record"
#define ST_FIRST_PAGE_NTX "First index page"
#define ST_TAG_LIST "Tag list"
#define ST_TAG_COUNT "Number of Tags"
#define ST_TAG_NAME "Tag"
#define ST_TAG_KEY "Key"
#define ST_TAG_TYPE "Type of tag"
#define ST_TAG_FILTER "Filter"
#define ST_KEY_TYPE "Key type"
#define ST_KEY_LEN "Key length"
#define ST_UNIQUE "unique"
#define ST_DESC "descending"
#define ST_DONE "done"

#endif
