/* tab_size = 8 */

/************************************************************************
* "Epsilon", "EEL" and "Lugaru" are trademarks of Lugaru Software, Ltd. *
*									*
*  Copyright (C) 1985, 1990 Lugaru Software Ltd.  All rights reserved.	*
*									*
* Limited permission is hereby granted to reproduce and modify this	*
* copyrighted material provided that the resulting code is used only in	*
* conjunction with Lugaru products and that this notice is retained in	*
* any such reproduction or modification.				*
*************************************************************************
*  The previous copyright and trademark notice applies to some of the	*
*  code herein. All other changes, enhancements and extension routines	*
*									*
*  Copyright (C) 1992 by Giovanni Zezza					*
*									*
*  These changes may be redistributed free allowed for any purpose	*
*  providing both the Lugaru and my copyrights remain intact.		*
*  I assume no liability for the use or inability to use		*
*  this software. Neither do I take responsibility for any damage	*
*  caused by this software extension.					*
*  This extension may NOT be redistributed for profit.			*
*************************************************************************
* File.......: DB_UTIL.E						*
* Ver........: 1.03                                                     *
* Date.......: 1992-10-06                                               *
* psilon ver: 5.00 & 6.00                                              *
* By.........: Giovanni Zezza						*
*     Address: via Basoli,1						*
*              40137 BOLOGNA						*
*     Country: ITALY							*
*     Tel....: Int +39-51-623 75 77 (GMT + 1h)                          *
*     Fax....: Int +39-51-33 06 66					*
*     FidoNet: 2:332/403 - Active - Bologna - Italy                     *
*************************************************************************
* Description: Some utility for dBase & Clipper Files:			*
*									*
*              ls_struct  : List the structure of the dBase file(s)	*
*									*
*              ls_ndx_key : Key expression and other informations	*
*			    about the dBIII Index File(s)		*
*									*
*              ls_ntx_key : Key expression and other informations	*
*			    about the Clipper Index File(s)		*
*									*
*              ls_mdx_key : Key Tag expression list and other		*
*			    informations about the dBIV Index File(s)	*
*									*
*	       ls_f4_info : F4FIELD_INFO struct from dBase file(s)    	*
*									*
*	       ls_t4_info : T4TAG_INFO struct from dBIV Index File(s)	*
*									*
*			    All the functions above write in the	*
*			    current buffer, and accept wildcards.	*
*									*
* Change log                                                            *
* Date      | Ver   | Change                                            *
* ----------+-------+-------------------------------------------------- *
*      1990 | 1.00  | (Personal use only - not truly released)          *
* 06-Oct-92 | 1.01  | dBIV mdx files tag list and string table.		*
* 10-Dec-92 | 1.02  | Some corrections to my pidgin English,		*
*	    |	    |    eleganter entry-point commands and		*
*	    |	    |	 some little fixes.				*
* 29-Jan-93 | 1.03  | CodeBase T4TAG_INFO & F4FIELD_INFO writer         *
* 01-Sep-93 | 1.04  | CodeBase 5.0 TAG4INFO & FIELD4INFO writer         *
*	    |	    |    via CB_version variable definition.
************************************************************************/

#include "eel.h"
#include "lowlevel.h"
#include "c:\eps\#i\dbase.h"
#define FIO_RO 0
#define FIO_WO 1
#define FIO_RW 2
#define FS_ABS 0
#define FS_REL 1
#define FS_END 2

int do_ls_mdx_key(/* char * nomefile */);
int do_ls_ndx_key(/* char * nomefile */);
int do_ls_ntx_key(/* char * nomefile */);
int do_ls_struct(/* char * nomefile */);
int do_f4_info(/* char * nome_file */);
int mdx_t4tag_info(/* char * nome_file */);
int ls_file_inf(/* int (*ls_func)(), char * sPrompt */);

#if EELVERSION >= 65
user int CB_version = 45;
#else
int CB_version = 45;
#endif

command ls_mdx_key()
{
	ls_file_inf((short) do_ls_mdx_key, ST_MDX_PROMPT);
}

command ls_t4_info()
{
	ls_file_inf((short) mdx_t4tag_info, ST_MDX_PROMPT);
}

command ls_f4_info()
{
	ls_file_inf((short) do_f4_info, ST_DBF_PROMPT);
}

command ls_ntx_key()
{
	ls_file_inf((short) do_ls_ntx_key, ST_NTX_PROMPT);
}

command ls_ndx_key()
{
	ls_file_inf((short) do_ls_ndx_key, ST_NDX_PROMPT);
}

command ls_struct()
{
	ls_file_inf((short) do_ls_struct, ST_DBF_PROMPT);
}


ls_file_inf(ls_func, sPrompt)
int (*ls_func)();
char * sPrompt;
{
	char nome_file[FNAMELEN],*t;
	t = "";
	get_file_dir(nome_file, sPrompt);
	if (t = file_match(nome_file, STARTMATCH | LISTMATCH)) {
		do {
			(*ls_func)(t);
			check_abort();
		} while (t =  file_match(nome_file,0));
		say ("%s", ST_DONE);
	}
}

do_ls_struct(nome_file)
char *nome_file;
{
	short db_handle, errore;
	int punt_file = 32,numero_campi = 0;
	int from,to,first = 1;
	DBF_HEADER struttura;
	DBF_FIELD campo;
	char c,*estensione;
	estensione = "";
	db_handle = lowopen(nome_file,FIO_RO);
	if (db_handle == -1) {
		file_error(errno, nome_file, ST_FILE_ERROR);
		return;
	}
	mark = point;
	lowread(db_handle,struttura.db_struct,32);
	if (struttura.db_header.signature !=   3 &&
		struttura.db_header.signature  != 131 &&
		struttura.db_header.signature  != 245 &&
		struttura.db_header.signature  != 139) {
		bprintf("*\t%s : %s\n",nome_file, ST_NOT_DBF);
		lowclose(db_handle);
		return;
	}
	bprintf("\n*\t%s : %s\n", ST_DBF_NAME, nome_file);
	bprintf("*\t%s : %02d", ST_LAST_UPDATE, struttura.db_header.ymd[2]);
	bprintf(".%02d",struttura.db_header.ymd[1]);
	bprintf(".%4d\n",1900+struttura.db_header.ymd[0]);
	bprintf("*\t%s : %d\n", ST_REC_COUNT, struttura.db_header.last_rec);
	bprintf("*\t%s : %d\n", ST_REC_LEN, struttura.db_header.rec_size);
	bprintf("*\t%s : %d\n\n", ST_DATA_OFF, struttura.db_header.data_off);
	estensione = get_extension(nome_file);
	c = *estensione;
	*estensione = '\0';
	bprintf("$file\t\t%s\n\n",get_tail(nome_file,0));
	*estensione = c;
	do {
		errore = lowread(db_handle,campo.db_struct,32);
		if (errore == -1) break;
		if (campo.db_field.field_name[0] == 0x0d) break;
		++numero_campi;
		to = strlen(campo.db_field.field_name);
		first = 1;
		for (from = 0; from<=to ; ++from) {
			c = campo.db_field.field_name[from];
			first ? (c = toupper(c)) : (c = tolower(c));
			campo.db_field.field_name[from] = c;
			first = !isalpha(c);
		}
		bprintf("%-10s\t",campo.db_field.field_name);
		bprintf("%-5c\t",campo.db_field.field_type);
		if (campo.db_field.field_type == 'C') {
			bprintf("%5d\t%5d\n",campo.db_field.len_info.char_len,0);
		} else {
			bprintf("%5d\t",campo.db_field.len_info.num_size.len);
			bprintf("%5d\n",campo.db_field.len_info.num_size.dec);
		}
		punt_file += 32;
	} while (punt_file <= struttura.db_header.data_off && !user_abort);
	bprintf("\n*\t%s :  %-d\n\n", ST_FIELDS_COUNT, numero_campi);
	bprintf("%s\n","* ---------------------------------");
	lowclose(db_handle);
}

do_ls_ntx_key(nome_file)
char *nome_file;
{
	short db_handle;
	NTX_HEADER indice;
	db_handle = lowopen(nome_file,FIO_RO);
	if (db_handle == -1) {
		file_error(errno, nome_file, ST_FILE_ERROR);
		return;
	}
	mark = point;
	lowread(db_handle,indice.ntx_struct,NTX_HEADER_PAGE);
	if (indice.ntx_header.sign != 3 && indice.ntx_header.sign != 6) {
		bprintf("*\t%s : %s\n",nome_file, ST_NOT_NTX);
		lowclose(db_handle);
		return;
	}
	bprintf("\n*\t%s : %s\n", ST_IDX_NAME, nome_file);
	bprintf("*\t%s : %-d\n", ST_IDX_VERSION, indice.ntx_header.version);
	bprintf("*\t%s ", ST_TAG_KEY);
	if (indice.ntx_header.unique == 1) bprintf("(%s) ", ST_UNIQUE);
	bprintf(": %s\n",indice.ntx_header.key_expr);
	bprintf("*\t%s : %-d", ST_KEY_LEN, indice.ntx_header.key_size);
	bprintf(".%-d\n",indice.ntx_header.key_dec);
	bprintf("*\t%s : %d\n", ST_FIRST_PAGE_NTX, indice.ntx_header.root);
	bprintf("%s\n","* ---------------------------------");
	lowclose(db_handle);
}

do_ls_ndx_key(nome_file)
char *nome_file;
{
	short db_handle;

	NDX_HEADER indice;
	db_handle = lowopen(nome_file,FIO_RO);
	if (db_handle == -1) {
		file_error(errno, nome_file, ST_FILE_ERROR);
		return;
	}
	mark = point;
	lowread(db_handle,indice.ndx_struct,NDX_HEADER_PAGE);
	bprintf("\n*\t%s : %s\n", ST_IDX_NAME, nome_file);
	bprintf("*\t%s ", ST_TAG_KEY);
	if (indice.ndx_header.unique == 1) bprintf("(%s) ", ST_UNIQUE);
	bprintf(": %s\n",indice.ndx_header.key_name);
	bprintf("*\t%s : %-d\n", ST_KEY_LEN, indice.ndx_header.index_key_len);
	bprintf("*\t%s : %-d\n", ST_KEY_TYPE, indice.ndx_header.ndx_key_type);
	bprintf("*\t%s : %d\n", ST_ROOT_REC, indice.ndx_header.start_key_page);
	bprintf("%s\n","* ---------------------------------");
	lowclose(db_handle);
}

do_ls_mdx_key(nome_file)
char *nome_file;
{
	short mdx_handle, errore;
	int tags_no = 0, num_tags = 0;
	int from, to, first = 1;
	MDX_HEADER mdx;
	TAG_DESC tag_desc;
	TAG_HEADER tag;
	EXPR_FILTER filter;

	char c;
	mdx_handle = lowopen(nome_file,FIO_RO);
	if (mdx_handle == -1) {
		file_error(errno, nome_file, ST_FILE_ERROR);
		return;
	}
	mark = point;
	lowread(mdx_handle, mdx.buf, sizeof(MDX_HEADER));
	if (mdx.stru.two !=   2 ) {
		bprintf("*\t%s : %s\n", nome_file, ST_NOT_MDX);
		lowclose(mdx_handle);
		return;
	}
	bprintf("\n*\t%s : %s\n", ST_IDX_NAME, nome_file);

	bprintf("*\t%s : %s - ", ST_ASSOCIATED_DBF, mdx.stru.data_name);

	if (mdx.stru.is_production) {
		bprintf("(%s)\n", ST_IS_PRODUCTION_MDX);
	} else {
		bprintf("(%s)\n", ST_NOT_PRODUCTION_MDX);
	}

	bprintf("*\t%s : %02d", ST_INDEX_CREATION, mdx.stru.create_date[2]);
	bprintf(".%02d",mdx.stru.create_date[1]);
	bprintf(".%4d\n",1900+mdx.stru.create_date[0]);

	bprintf("*\t%s : %02d", ST_LAST_UPDATE, mdx.stru.yymmdd[2]);
	bprintf(".%02d",mdx.stru.yymmdd[1]);
	bprintf(".%4d\n",1900+mdx.stru.yymmdd[0]);

	num_tags = mdx.stru.num_tags & 0x000000FF;
	bprintf("*\t%s : %d\n", ST_TAG_COUNT, num_tags);
	bprintf("\n*\t--- %s ---\n", ST_TAG_LIST);
	do {
		bprintf("\n");
		errore = lowseek(mdx_handle, TAG_DESC_POS + (tags_no * sizeof(TAG_DESC)), FS_ABS);
		if (errore == -1) break;
		errore = lowread(mdx_handle, tag_desc.buf, sizeof(TAG_DESC));
		if (errore == -1) break;
		++tags_no;
		to = strlen(tag_desc.stru.tag);
		first = 1;
		for (from = 0; from<=to ; ++from) {
			c = tag_desc.stru.tag[from];
			first ? (c = toupper(c)) : (c = tolower(c));
			tag_desc.stru.tag[from] = c;
			first = !isalpha(c);
		}
		bprintf("*\t%s : %-10s\t", ST_TAG_NAME, tag_desc.stru.tag);
		errore = lowseek(mdx_handle, tag_desc.stru.header_pos * BLOCK_LEN, FS_ABS);
		if (errore == -1) break;
		errore = lowread(mdx_handle, tag.buf, sizeof(TAG_HEADER));
		if (errore == -1) break;
		if (tag.stru.type_code & UNIQ_KEY) {
			bprintf("(%s) ", ST_UNIQUE);
		}
		if (tag.stru.type_code & DESC_KEY) {
			bprintf("(%s)", ST_DESC);
		}
		bprintf("\n");

		bprintf("*\t%s : %s\n", ST_TAG_KEY, tag.stru.expr_key);
		errore = lowseek(mdx_handle, tag_desc.stru.header_pos * BLOCK_LEN + EXPR_FILTER_POS, FS_ABS);
		if (errore == -1) break;
		errore = lowread(mdx_handle, filter, sizeof(EXPR_FILTER));
		if (errore == -1) break;
		bprintf("*\t%s : %s\n", ST_TAG_FILTER, filter);
		bprintf("*\t%s : %-5c\t", ST_KEY_TYPE, tag.stru.type);
		bprintf("%s : %d\n", ST_KEY_LEN, tag.stru.value_len);

	} while (tags_no < num_tags && !user_abort);
	bprintf("\n%s\n","* ---------------------------------");
	lowclose(mdx_handle);
}

mdx_t4tag_info(nome_file)
char *nome_file;
{
	short mdx_handle, errore;
	int tags_no = 0, num_tags = 0;
	int from, to;
	MDX_HEADER mdx;
	TAG_DESC tag_desc;
	TAG_HEADER tag;
	EXPR_FILTER filter;

	char c, *estensione, *pc_from, *pc_to;
	estensione = "";
	pc_to = "";
	pc_from = "";

	mdx_handle = lowopen(nome_file,FIO_RO);
	if (mdx_handle == -1) {
		file_error(errno, nome_file, ST_FILE_ERROR);
		return;
	}
	mark = point;
	lowread(mdx_handle, mdx.buf, sizeof(MDX_HEADER));
	if (mdx.stru.two !=   2 ) {
		bprintf("/*\t%s : %s */\n", nome_file, ST_NOT_MDX);
		lowclose(mdx_handle);
		return;
	}
	bprintf("/*\n|\t%s : %s\n", ST_IDX_NAME, nome_file);

	bprintf("|\t%s : %s - ", ST_ASSOCIATED_DBF, mdx.stru.data_name);

	if (mdx.stru.is_production) {
		bprintf("(%s)\n", ST_IS_PRODUCTION_MDX);
	} else {
		bprintf("(%s)\n", ST_NOT_PRODUCTION_MDX);
	}

	bprintf("|\t%s : %02d", ST_INDEX_CREATION, mdx.stru.create_date[2]);
	bprintf(".%02d",mdx.stru.create_date[1]);
	bprintf(".%4d\n",1900+mdx.stru.create_date[0]);

	bprintf("|\t%s : %02d", ST_LAST_UPDATE, mdx.stru.yymmdd[2]);
	bprintf(".%02d",mdx.stru.yymmdd[1]);
	bprintf(".%4d\n",1900+mdx.stru.yymmdd[0]);

	num_tags = mdx.stru.num_tags & 0x000000FF;
	bprintf("|\t%s : %d\n*/\n", ST_TAG_COUNT, num_tags);

	estensione = get_extension(nome_file);
	c = *estensione;
	*estensione = '\0';
	if (CB_version <= 45) {
	   bprintf("\nT4TAG_INFO %s_tags[] = \n{\n",get_tail(nome_file,0));
	} else if (CB_version == 50) {
	   bprintf("\nTAG4INFO %s_tags[] = \n{\n",get_tail(nome_file,0));
	}
	*estensione = c;

	do {
		errore = lowseek(mdx_handle, TAG_DESC_POS + (tags_no * sizeof(TAG_DESC)), FS_ABS);
		if (errore == -1) break;
		errore = lowread(mdx_handle, tag_desc.buf, sizeof(TAG_DESC));
		if (errore == -1) break;
		++tags_no;
		to = strlen(tag_desc.stru.tag);
		for (from = 0; from<=to ; ++from) {
			tag_desc.stru.tag[from] = toupper(tag_desc.stru.tag[from]);
		}
		
		bprintf("\t{ \"%s\", ", tag_desc.stru.tag);

		errore = lowseek(mdx_handle, tag_desc.stru.header_pos * BLOCK_LEN, FS_ABS);
		if (errore == -1) break;
		errore = lowread(mdx_handle, tag.buf, sizeof(TAG_HEADER));
		if (errore == -1) break;

		stuff("\"");
		pc_from = tag.stru.expr_key;
		while (pc_to = index(pc_from, '"')) {
			*pc_to = '\0';
			bprintf("%s\\\"", pc_from);
			*pc_to = '"';
			pc_from = pc_to + 1;
		}
		bprintf("%s\", ", pc_from);
		
		errore = lowseek(mdx_handle, tag_desc.stru.header_pos * BLOCK_LEN + EXPR_FILTER_POS, FS_ABS);
		if (errore == -1) break;
		errore = lowread(mdx_handle, filter, sizeof(EXPR_FILTER));
		if (errore == -1) break;

		stuff("\"");
		pc_from = filter;
		while (pc_to = index(pc_from, '"')) {
			*pc_to = '\0';
			bprintf("%s\\\"", pc_from);
			*pc_to = '"';
			pc_from = pc_to + 1;
		}
		bprintf("%s\", ", pc_from);
		

		if (tag.stru.type_code & UNIQ_KEY) {
			bprintf("%s, ", "r4unique_continue");
		} else {
			bprintf("%s, ", "0");			
		}
		if (tag.stru.type_code & DESC_KEY) {
			bprintf("%s },\n", "r4descending");
		} else {
			bprintf("%s },\n", "0");
		}

	} while (tags_no < num_tags && !user_abort);
		
	bprintf("\t{ 0, 0, 0, 0, 0 }\n};\n");
	bprintf("\n%s\n\n\n\n","/* --------------------------------- */");
	lowclose(mdx_handle);
}

do_f4_info(nome_file)
char *nome_file;
{
	short db_handle, errore;
	int punt_file = 32,numero_campi = 0;
	int from,to = 1;
	DBF_HEADER struttura;
	DBF_FIELD campo;
	char c,*estensione;
	estensione = "";
	db_handle = lowopen(nome_file,FIO_RO);
	if (db_handle == -1) {
		file_error(errno, nome_file, ST_FILE_ERROR);
		return;
	}
	mark = point;
	lowread(db_handle,struttura.db_struct,32);
	if (struttura.db_header.signature !=   3 &&
		struttura.db_header.signature  != 131 &&
		struttura.db_header.signature  != 245 &&
		struttura.db_header.signature  != 139) {
		bprintf("/*\t%s : %s */\n",nome_file, ST_NOT_DBF);
		lowclose(db_handle);
		return;
	}
	bprintf("\n/*\n|\t%s : %s\n", ST_DBF_NAME, nome_file);
	bprintf("|\t%s : %02d", ST_LAST_UPDATE, struttura.db_header.ymd[2]);
	bprintf(".%02d",struttura.db_header.ymd[1]);
	bprintf(".%4d\n",1900+struttura.db_header.ymd[0]);
	bprintf("|\t%s : %d\n", ST_REC_COUNT, struttura.db_header.last_rec);
	bprintf("|\t%s : %d\n", ST_REC_LEN, struttura.db_header.rec_size);
	bprintf("|\t%s : %d\n*/\n\n", ST_DATA_OFF, struttura.db_header.data_off);
	estensione = get_extension(nome_file);
	c = *estensione;
	*estensione = '\0';
	if (CB_version <= 45) {
	   bprintf("F4FIELD_INFO %s_fields[] = \n{\n",get_tail(nome_file,0));
	} else if (CB_version == 50) {
	   bprintf("FIELD4INFO %s_fields[] = \n{\n",get_tail(nome_file,0));
	}
	*estensione = c;
	do {
		errore = lowread(db_handle,campo.db_struct,32);
		if (errore == -1) break;
		if (campo.db_field.field_name[0] == 0x0d) break;
		++numero_campi;
		to = strlen(campo.db_field.field_name);
		for (from = 0; from<=to ; ++from) {
			campo.db_field.field_name[from] = toupper(campo.db_field.field_name[from]);
		}
		bprintf("\t{ \"%s\",", campo.db_field.field_name);
		to_column(tab_size + 17);
		bprintf("\"%c\", ", campo.db_field.field_type);
		if (campo.db_field.field_type == 'C') {
			bprintf("%5d, %5d},\n",campo.db_field.len_info.char_len,0);
		} else {
			bprintf("%5d, ",campo.db_field.len_info.num_size.len);
			bprintf("%5d},\n",campo.db_field.len_info.num_size.dec);
		}
		punt_file += 32;
	} while (punt_file <= struttura.db_header.data_off && !user_abort);
	bprintf("\t{ 0, 0, 0, 0 }\n};\n");
	bprintf("\n/* ----------   %s :  %-d   ---------- */\n\n\n", ST_FIELDS_COUNT, numero_campi);
	lowclose(db_handle);
}
