// pluck.e $Revision: 1.3 $
//
// Mon, 09/19/1994 22:08:10
//
// Purpose:
//
//		This command is similar to find-file but will use the file
//		found at the current buffer location to load.  If a file
//		specification cannot be found in the buffer then this behaves
//		identically to find_file.  This makes short work of viewing
//		and editing referenced files such as include files or
//		reference sources.
//
//		The file specification parsed is as follows:
//
//		<DRIVE>:<FILESPEC>(<LINE>:<COLUMN>)
//
//		ie.
//
//		c:/foo/bar/boo.c(25:14) means the file boo.c in the
//		subdirectory /foo/bar in the C drive on line 25 at column 14.
//
//
// Usage:
//
//		You would normally use this command to specify a file to
//		edit.  This command prompts you for a file name, then scans
//		the buffers to see if any of them contain that file.  If so,
//		the command displays that buffer in the current window.
//
//		Otherwise, the command creates a buffer with the same name as
//		the file, possibly modified to make it different from the
//		names of nonempty buffers, then reads the file into this
//		buffer, then displays that buffer in the current window.
//		With a numeric argument, the command reads the file in
//		untranslated mode and sets the buffer to this mode (see
//		set-line-translate).  (Under Unix, a numeric argument means
//		to read in translated mode.)
//
//
// Details:
//
//
// Some future directions:
//
//
// The modifications to this code are dedicated to the public domain
// with the caveat that Lugaru is welcome to use this within their
// distribution source code which is supplied with Epsilon.  Use it
// any way you want for whatever purposes.
//
//
//	John Kercheval
//	15563 10th Ave NE
//	Seattle, WA 98155-6209
//	INTERNET: johnk@wrq.com
//	Compu$erve: 72450,3702
//
//
// Modification History:
//
//		Sun, 09/18/1994 13:42:07 V1.0 release.  The code from which
//		this was created was found on the Lugaru BBS.  I have since
//		lost the author info.  Thanks to the Author. 
//
//		Fri, 12/09/1994 21:25:26 V1.1 release.  Correct a bug parsing
//		path names with drives other than the current drive.  The
//		drive group match was not being checked at all.
//

#include <eel.h>

#ifndef BOOL
#define BOOL int
#define TRUE 1
#define FALSE 0
#endif

#define MAX_BUF		256

#define FILE_PATTERN "[a-zA-Z0-9_\x80-\x9A\xA0-\xA5%.%(%){}%\\~!@#%$%%%^&%-%+=]+"

#define	DRIVE	"([a-zA-Z]:)?"
#define	FNAME	DRIVE "(" FILE_PATTERN ")"

#define	LPAREN	"[ \\(]*"
#define	NUMBER	"([0-9]+)"
#define	RPAREN	"[ \\)]+"

#define	FNAME_PATTERN	FNAME "(" LPAREN NUMBER "(:" NUMBER ")?" RPAREN ")?"

#define DRIVE_PAREN		1
#define	FNAME_PAREN		2
#define	LINENO_PAREN	4
#define	COLUMN_PAREN	6


////////////////////////////////////////////////////////////////////////////
//
// parse_file_specification will obtain from the current buffer a
// file spec.  The format of the file spec is "FILESPEC(LINE:COLUMN)"
// ie.
//
// x:\foo\bar\boo\filename.c(25:10)  would specify the file
// filename.c in the \foo\bar\boo subdirectory on drive x on line 25
// and on column 10.
//
// No 8.3 error checking...
//
//
BOOL
parse_file_specification(fname, line, column)
	char *fname;
	int *line;
	int *column;
{
	char lineString[MAX_BUF+1];	// line string
	char columnString[MAX_BUF+1]; // column string

 	int groupBegin;				// beginning of matching group
	int groupEnd;				// end of matching group

	save_spot point;			// don't lose the current place
	save_spot mark;				//   in the file.

	//
	// init
	//
	fname[0] = '\0';
	lineString[0] = '\0';
	columnString[0] = '\0';

	*line = 0;
	*column = 0;

	//
	// back up one to catch the end of the pattern, then find the
	// pattern forward and back to get the entire pattern.
	//
	point--;
	re_search(1, FNAME_PATTERN);
	re_search(-1, FNAME_PATTERN);

	//
	// move over the pattern a last time to match the groups
	//
	parse_string(1, FNAME_PATTERN, NULL);

	//
	// obtain the filename
	//
	groupBegin = find_group(DRIVE_PAREN, TRUE);
	if (groupBegin < 0) {
		groupBegin = find_group(FNAME_PAREN, TRUE);
	}
	groupEnd = find_group(FNAME_PAREN, FALSE);
	if (groupBegin < 0 ||
		groupEnd < 0) {
		return FALSE;
	} else {
		grab(groupBegin, groupEnd, fname);
	}
	
	//
	// obtain the line number
	//
	groupBegin = find_group(LINENO_PAREN, TRUE);
	groupEnd = find_group(LINENO_PAREN, FALSE);
	if (groupBegin >= 0 &&
		groupEnd >= 0) {
		grab(groupBegin, groupEnd, lineString);
	}
	*line = strtoi(lineString, 10);
	if (got_bad_number) {
		*line = 0;
	}

	//
	// obtain the column number
	//
	groupBegin = find_group(COLUMN_PAREN, TRUE);
	groupEnd = find_group(COLUMN_PAREN, FALSE);
	if (groupBegin >= 0 &&
		groupEnd >= 0) {
		grab(groupBegin, groupEnd, columnString);
	}
	*column = strtoi(columnString, 10);
	if (got_bad_number) {
		*column = 0;
	}

	return TRUE;
}


////////////////////////////////////////////////////////////////////////////
//
// pluck_file will obtain the file name at the current buffer's
// cursor location and will read it in.
//
//
command
pluck_file()
	on  cx_tab[CTRL('J')]
{
	BOOL fnameFound;			// TRUE if a file pattern found

	char fname[FNAMELEN];		// The file pattern to open
	char openfname[FNAMELEN];	// The file to open
	char *full_fname;			// The completed file
	char def[FNAMELEN];			// The plucked default file

	int lineNumber;				// The line number of the file
	int columnNumber;			// The column number of the file

	iter = 0;

	//
	// obtain the file name from the buffer
	//
	fnameFound = parse_file_specification(def, &lineNumber, &columnNumber);

	//
	// if there is an argument then the filename found in the buffer
	// is simply a default for find_file
	//
	if (!fnameFound) {
		get_file(fname, "Find file", def);
	} else {
		strcpy(fname, def);
	}

	//
	// get the full path of the completed file, if the file is a new
	// one then just open it using the fname return.
	//
	quiet_set_bookmark();
	full_fname = do_file_match(fname, FM_EXACT);
	if (!full_fname) {
		strcpy(openfname, fname);
		absolute(openfname);
		do_find(openfname, has_arg ? !strip_returns.default
				: strip_returns.default);
	} else {
		while (full_fname != NULL) {
			strcpy(openfname, full_fname);
			absolute(openfname);
			do_find(openfname, has_arg ? !strip_returns.default
					: strip_returns.default);
			if (lineNumber) {
				go_line(lineNumber);
			}
			if (columnNumber) {
				move_to_column(columnNumber);
			}
			full_fname = do_file_match(fname, 0);
		}
	}
}


